@extends('frontend.layouts.app')
@section('content')
    <!-- ---------- Profile ---------- -->
    <!-- ---------- Profile ---------- -->
    <section class="hero">
        <div class="container">
            <div class="profile">
                <div>
                    <div class="id_profile">
                        <div class="text_id_profile">
                            <div class="img_icon_profile">
                                <form action="{{ route('update.profile.image') }}" method="post" enctype="multipart/form-data"
                                    id="profilePicForm">
                                    @csrf
                                    @method('PUT')
                                    <div class="img_profile">
                                        @if ($UserProfile && $UserProfile->ProfileImage)
                                            <img src="{{ asset('user/' . $UserProfile->ProfileImage) }}" alt="Profile Image"
                                                id="profileImagePreview">
                                        @else
                                            <img src="{{ asset('default-image.jpg') }}" alt="Default Profile Image"
                                                id="profileImagePreview">
                                        @endif
                                    </div>
                                    <input type="file" name="ProfileImage">
                                    <button type="submit" id="submitBtn">Update</button>
                                </form>
                            </div>
                            <h3>{{ $user->name }}</h3>
                            <p>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-telephone" viewBox="0 0 16 16">
                                    <path
                                        d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                                </svg>
                                <span>{{ $user->phone }}</span>
                            </p>
                            <p>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                    <path
                                        d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                                </svg>
                                <span>{{ $user->email }}</span>
                            </p>
                            <hr>
                        </div>
                        <div class="content_profile">
                            <div class="item_profile">
                                <p>
                                    <span>Do you want to <br> donate Blood ?</span>
                                </p>
                                <div style="display: flex; gap: 5px;">
                                    <h4 class="varefy_profile" id="bloodWant">Yes</h4>
                                    <h4 class="varefy_profile">No</h4>
                                </div>
                            </div>
                            <div class="item_profile">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                                    </svg>
                                    <span>NID</span>
                                </p>
                                <h4 class="varefy_profile">Verify</h4>
                            </div>
                            <div class="item_profile">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                                    </svg>
                                    <span>BRN</span>
                                </p>
                                <h4 class="varefy_profile">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                                        <path
                                            d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z" />
                                    </svg>
                                </h4>
                            </div>
                            <div class="item_profile">
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                                    </svg>
                                    <span>Password</span>
                                </p>
                                <h4 class="varefy_profile">Edit</h4>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- adderss profile -->
                <div class="adderss_profile">
                    <!-- <h4>Profile</h4> -->
                    {{-- <div class="all_profile">
                        <div class="profile_content">
                            <div class="profile_item active">
                                <h4>My <br> Profile</h4>
                            </div>
                            <div class="profile_item">
                                <h4>Birthplace <br> Address</h4>
                            </div>
                            <div class="profile_item">
                                <h4>Parmament <br> Address</h4>
                            </div>
                            <div class="profile_item">
                                <h4>Current <br> Address</h4>
                            </div>
                            <div class="profile_item">
                                <h4>Check & <br> Review</h4>
                            </div>
                        </div>
                    </div> --}}
                    <div class="data_profile">
                        <form action="{{ route('profile.create') }}" method="post">
                            @csrf
                            <div class="profile_items" id="Profile">
                                <!-- My Profile -->


                                <h2>My Profile</h2>
                                <div class="alert alert-danger errorField" role="alert">
                                    <p style="color: red;padding-top:5px;padding-left:5px">Please fill out This field</p>
                                </div>

                                <div class="profile_form">
                                    <div class="form_group">
                                        <label for="name">Name</label>
                                        <input type="text" name="Name" id="name" placeholder="Your Name"
                                            value="{{ $user->name }}" class="form-control" required>
                                        <input type="hidden" name="User_id" value="{{ $user->id }}">

                                    </div>

                                    <div class="form_group">
                                        <label for="fatherName">Father Name</label>
                                        <input type="text" class="errorfather" name="FatherName"
                                            value="{{ $UserProfile ? $UserProfile->FatherName : '' }}" id="fatherName"
                                            placeholder="Father Name">

                                    </div>

                                    <div class="form_group">
                                        <label for="motherName">Mother Name</label>
                                        <input type="text" class="errormother" name="MotherName"
                                            value="{{ $UserProfile ? $UserProfile->MotherName : '' }}" id="motherName"
                                            placeholder="Mother Name">
                                    </div>

                                    <div class="form_group">
                                        <label for="gender">Gender</label>
                                        <div class="form_select">
                                            <select name="Gender">
                                                <option value="none">Select</option>
                                                @if ($UserProfile)
                                                    @if ($UserProfile->Gender == 'male')
                                                        <option value="male" selected>Male</option>
                                                        <option value="female">Female</option>
                                                        <option value="other">Other</option>
                                                    @elseif ($UserProfile->Gender == 'female')
                                                        <option value="male">Male</option>
                                                        <option value="female" selected>Female</option>
                                                        <option value="other">Other</option>
                                                    @elseif ($UserProfile->Gender == 'other')
                                                        <option value="male">Male</option>
                                                        <option value="female">Female</option>
                                                        <option value="other" selected>Other</option>
                                                    @endif
                                                @else
                                                    <option value="male">Male</option>
                                                    <option value="female">Female</option>
                                                    <option value="other">Other</option>
                                                @endif

                                            </select>
                                        </div>
                                    </div>

                                    <div class="form_group">
                                        <label for="email">Email</label>
                                        <input type="email" name="Email" id="email"
                                            class="form-control erroremail"
                                            value="{{ $user->email }}"placeholder="Email">
                                    </div>
                                    <div class="form_group">
                                        <label for="phone">Phone</label>
                                        <input type="text" name="AnotherPhone" id="phone"
                                            value="{{ $UserProfile && $UserProfile->AnotherPhone ? $UserProfile->AnotherPhone : '+880' }}"
                                            placeholder="Phone" class="form-control errorphone" required>
                                    </div>


                                    <div class="form_group">
                                        <label for="blood">Blood Group</label>
                                        <div class="form_select">
                                            <select id="BloodGroup" name="BloodGroup">
                                                <option value="none">Select</option>
                                                @foreach ($BloodGroup as $name)
                                                    <option value="{{ $name->bloodGroup }}">
                                                        {{ $name->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>


                                    <div class="form_group">
                                        <label for="occupation">Profession</label>
                                        <div class="form_select">
                                            <select id="gender" name="Occupation">

                                                <option value="none">Select</option>
                                                @foreach ($professions as $profession)
                                                    <option value="{{ $profession->id }}">{{ $profession->title }}
                                                    </option>
                                                @endforeach
                                                {{-- @if ($UserProfile)
                                                    @if ($UserProfile->Occupation == 'male')
                                                        <option value="Acoountant" selected>Acoountant</option>
                                                        <option value="Manger">Manger</option>
                                                        <option value="Admin">Admin</option>
                                                    @elseif ($UserProfile->Occupation == 'Manger')
                                                        <option value="Acoountant">Acoountant</option>
                                                        <option value="Manger" selected>Manger</option>
                                                        <option value="Admin">Admin</option>
                                                    @elseif ($UserProfile->Occupation == 'Admin')
                                                        <option value="Acoountant">Acoountant</option>
                                                        <option value="Manger">Manger</option>
                                                        <option value="Admin" selected>Admin</option>
                                                    @endif
                                                @else
                                                    <option value="Acoountant">Acoountant</option>
                                                    <option value="Manger">Manger</option>
                                                    <option value="Admin">Admin</option>
                                                @endif --}}

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="MaritalStatus">Marital Status:</label>
                                        <div class="form_select">
                                            <select id="gender" name="MaritalStatus">
                                                <option value="none"
                                                    {{ optional($UserProfile)->MaritalStatus == 'none' ? 'selected' : '' }}>
                                                    Select</option>
                                                <option value="single"
                                                    {{ optional($UserProfile)->MaritalStatus == 'single' ? 'selected' : '' }}>
                                                    Unmarried</option>
                                                <option value="married"
                                                    {{ optional($UserProfile)->MaritalStatus == 'married' ? 'selected' : '' }}>
                                                    Married</option>
                                                <option value="widowed"
                                                    {{ optional($UserProfile)->MaritalStatus == 'widowed' ? 'selected' : '' }}>
                                                    Widowed</option>
                                                <option value="divorced"
                                                    {{ optional($UserProfile)->MaritalStatus == 'divorced' ? 'selected' : '' }}>
                                                    Divorced</option>
                                                <option value="legally"
                                                    {{ optional($UserProfile)->MaritalStatus == 'legally' ? 'selected' : '' }}>
                                                    Legally Separated</option>
                                                <option value="domestic"
                                                    {{ optional($UserProfile)->MaritalStatus == 'domestic' ? 'selected' : '' }}>
                                                    Cohabiting</option>
                                            </select>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="profile_items" id="Birthplace">
                                <h2>Birthplace Address</h2>
                                <div class="profile_form">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <div class="form_select">
                                            <select class="BirthplaceDivisions" name="BirthplaceDivision">
                                                <option value="">-Select-</option>
                                                @foreach ($Division as $name)
                                                    @if ($UserProfile)
                                                        <option
                                                            {{ $name->id == $UserProfile->BirthplaceDivision ? 'selected' : '' }}
                                                            value="{{ $name->id }}">{{ $name->title }}</option>
                                                    @endif
                                                    <option value="{{ $name->id }}">{{ $name->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <div class="form_select">
                                            <select class="BirthplaceDistricts" name="BirthplaceDistrict">
                                                <option value="">-Select-</option>
                                                @foreach ($District as $item)
                                                    @if ($UserProfile)
                                                        <option
                                                            {{ $item->id == $UserProfile->BirthplaceDistrict ? 'selected' : 'disabled' }}
                                                            value="{{ $item->id }}">{{ $item->title }}</option>
                                                    @endif
                                                    <option value="{{ $item->id }}">{{ $item->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <div class="form_select">
                                            <select class="BirthplaceUpzillas" class="BirthplaceUpzilla">
                                                <option value="">-Select-</option>
                                                @foreach ($Upazilla as $item)
                                                    @if ($UserProfile)
                                                        <option
                                                            {{ $item->id == $UserProfile->BirthplaceUpzilla ? 'selected' : 'disabled' }}
                                                            value="{{ $item->id }}">{{ $item->title }}</option>
                                                    @endif
                                                    <option value="{{ $item->id }}">{{ $item->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <div class="form_select">
                                            <select class="BirthplaceUnions" class="BirthplaceUnion">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <div class="form_select">
                                            <select class="BirthplaceWards" name="BirthplaceWard">

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <div class="form_select">
                                            <select class="BirthplaceVillages" name="BirthplaceVillage">

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="profile_items" id="Parmament">
                                <!-- current Address -->
                                <h2>Permament Address</h2>

                                <div class="profile_form">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <div class="form_select">
                                            <select class="PermanentDivisions" name="PermanentDivision">
                                                <option value="">-Select-</option>
                                                @foreach ($Division as $name)
                                                    <option value="{{ $name->id }}">{{ $name->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <div class="form_select">
                                            <select class="PermanentDistricts" name="PermanentDistrict">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <div class="form_select">
                                            <select class="PermanenteUpzillas" name="PermanentUpzilla">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <div class="form_select">
                                            <select class="PermanentUnions" name="PermanentUnion">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <div class="form_select">
                                            <select class="PermanentWards" name="PermanentWard">

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <div class="form_select">
                                            <select class="PermanentVillages" name="PermanentVillage">

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="profile_items" id="Current">
                                <!-- current Address -->
                                <h2>Current Adderss</h2>
                                <div class="profile_form">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <div class="form_select">
                                            <select class="CurrentDivisions" name="CurrentDivision">
                                                <option value="">-Select-</option>
                                                @foreach ($Division as $name)
                                                    <option value="{{ $name->id }}">{{ $name->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <div class="form_select">
                                            <select class="CurrentDistricts" name="CurrentDistrict">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <div class="form_select">
                                            <select class="CurrentUpzillas" name="CurrentUpzilla">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <div class="form_select">
                                            <select class="CurrentUnions" name="CurrentUnion">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <div class="form_select">
                                            <select class="CurrentWard" name="CurrentWard">

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <div class="form_select">
                                            <select class="CurrentVillage" name="CurrentVillage">

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="profile_countinue" id="myFunctionFive">Submit</button>
                            <style>
                                .profile_countinue {
                                    margin-top: 10px;
                                    margin-left: 30px;
                                    margin-bottom: 50px
                                }

                                .profile_countinue {
                                    margin-top: 10px;
                                    margin-left: 30px;
                                    margin-bottom: 50px;
                                }

                                /* Style for the back button */
                                .profile_back {
                                    background-color: #f0f0f0;
                                    /* Customize as needed */
                                    color: #333;
                                    padding: 10px 20px;
                                    border: none;
                                    cursor: pointer;
                                    margin-bottom: 20px;
                                }

                                .profile_back:hover {
                                    background-color: #ccc;
                                }
                            </style>
                        </form>
                        <button id="myFunctionOne" class="profile_countinue">Countinue</button>
                        <button id="myFunctionTwo" class="profile_countinue">Countinue</button>
                        <button id="myFunctionThree" class="profile_countinue">Countinue </button>
                        <button id="myFunctionFour" class="profile_countinue">Countinue</button>
                        <button id="backFunctionTwo" class="profile_countinue">Back</button>
                        {{-- <button id="backFunctionThree" class="profile_countinue">Countinue</button>
                        <button id="backFunctionFour" class="profile_countinue">Countinue </button> --}}
                    </div>

                </div>
            </div>
        </div>
        <div class="overlay"></div>
        <div class="bloodPopup">
            <form action="#" method="post">
                <div class="form_group">
                    <label for="weight">Weight</label>
                    <input type="number" id="weight" placeholder="Your Eeight" required>
                </div>
                <div class="form_group">
                    <label for="age">Age</label>
                    <input type="number" id="age" placeholder="Your Age" required>
                </div>
                <div class="form_group">
                    <label for="sms">Massage</label>
                    <textarea id="sms" rows="5" placeholder="Massage"></textarea>
                </div>
                <div class="profile_countinue">
                    <input type="submit" value="Submit">
                </div>
            </form>
        </div>
    </section>
    <!-- ---------- Profile end ---------- -->

    <script>
        // Profile Information hide and show

        // div
        $("#Profile").show();
        $("#Birthplace").hide();
        $("#Parmament").hide();
        $("#Current").hide();

        // button
        $("#myFunctionOne").show();
        $("#myFunctionTwo").hide();
        $("#myFunctionThree").hide();
        $("#myFunctionFour").hide();
        $("#myFunctionFive").hide();

        //Error
        $(".errorField").hide();



        $('.errorfather').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.errormother').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.erroremail').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.errorphone').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $("#myFunctionOne").click(function() {
            var father = $('.errorfather').val();
            var mother = $('.errormother').val();
            var email = $('.erroremail').val();
            var phone = $('.errorphone').val();
            if (father && mother && email && phone) {
                $("#Profile").hide();
                $("#Birthplace").show();

                $("#myFunctionOne").hide();
                $("#myFunctionTwo").show();

            } else {
                $(".errorField").show();
            }


        });

        $("#myFunctionTwo").click(function() {
            $("#Profile").hide();
            $("#Birthplace").hide();
            $("#Parmament").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").show();
        });

        $("#myFunctionThree").click(function() {
            $("#Profile").hide();
            $("#Birthplace").hide();
            $("#Parmament").hide();
            $("#Current").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").hide();
            $("#myFunctionFour").show();
        });
        $("#myFunctionFour").click(function() {
            $("#Profile").show();
            $("#Birthplace").show();
            $("#Parmament").show();
            $("#Current").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").hide();
            $("#myFunctionFour").hide();
            $("#myFunctionFive").show();
        });


        // Back button functions
        $("#backFunctionTwo").click(function() {
            $("#Birthplace").hide();
            $("#Profile").show();
            $("#myFunctionTwo").hide();
            $("#myFunctionOne").show();
        });

        $("#backFunctionThree").click(function() {
            $("#Parmament").hide();
            $("#Birthplace").show();
            $("#myFunctionThree").hide();
            $("#myFunctionTwo").show();
        });

        $("#backFunctionFour").click(function() {
            $("#Current").hide();
            $("#Parmament").show();
            $("#myFunctionFour").hide();
            $("#myFunctionThree").show();
        });


        //Birthplace Address------------ Division BY District ajax Request
        $(document).on('change', '.BirthplaceDivisions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.BirthplaceDistricts').empty();
                    $('.BirthplaceDistricts').append(txt);
                },

                error: function(error) {
                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // District BY Upzilla ajax Request
        $(document).on('change', '.BirthplaceDistricts', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="" selected>-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.BirthplaceUpzillas').empty();
                    $('.BirthplaceUpzillas').append(txt);



                },

                error: function(error) {
                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Upzilla BY Union ajax Request
        $(document).on('change', '.BirthplaceUpzillas', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.BirthplaceUnions').empty();
                    $('.BirthplaceUnions').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.BirthplaceUnions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.BirthplaceWards').empty();
                    $('.BirthplaceWards').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.BirthplaceWards', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.BirthplaceVillages').empty();
                    $('.BirthplaceVillages').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });





        //Parmament Address------------ Division BY District ajax Request
        $(document).on('change', '.PermanentDivisions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.PermanentDistricts').empty();
                    $('.PermanentDistricts').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // District BY Upzilla ajax Request
        $(document).on('change', '.PermanentDistricts', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.PermanenteUpzillas').empty();
                    $('.PermanenteUpzillas').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Upzilla BY Union ajax Request
        $(document).on('change', '.PermanenteUpzillas', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.PermanentUnions').empty();
                    $('.PermanentUnions').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.PermanentUnions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.PermanentWards').empty();
                    $('.PermanentWards').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.PermanentWards', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.PermanentVillages').empty();
                    $('.PermanentVillages').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });


        //Current Adderss------------ Division BY District ajax Request
        $(document).on('change', '.CurrentDivisions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.CurrentDistricts').empty();
                    $('.CurrentDistricts').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // District BY Upzilla ajax Request
        $(document).on('change', '.CurrentDistricts', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.CurrentUpzillas').empty();
                    $('.CurrentUpzillas').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Upzilla BY Union ajax Request
        $(document).on('change', '.CurrentUpzillas', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.CurrentUnions').empty();
                    $('.CurrentUnions').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.CurrentUnions', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.CurrentWard').empty();
                    $('.CurrentWard').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });
        // Union BY Ward ajax Request
        $(document).on('change', '.CurrentWard', function() {
            var id = $(this).val();

            // console.log(uom);
            // Ajax Request Start

            $_token = "{{ csrf_token() }}";

            // Ajax Request Start
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                }, //see the _token
                datatype: 'application/json',

                beforeSend: function() {
                    // show waiting dialog
                    // waitingDialog.show('Loading...');
                },

                success: function(data) {
                    // hide waiting dialog

                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    // $('.BirthplaceDistrictss').select2();
                    $('.CurrentVillage').empty();
                    $('.CurrentVillage').append(txt);



                },

                error: function(error) {
                    // hide waiting dialog
                    // waitingDialog.hide();

                    console.log(error);
                }
            });
            // Ajax Request End

        });

        // header
        const navToggol = document.querySelector('.nav_toggol');
        const closeToggol = document.querySelector('.close_toggol');
        navToggol.addEventListener('click', function() {
            document.querySelector('.nav_list').classList.add('show_list');
            closeToggol.style.display = "block"
            navToggol.style.display = "none"
        })

        closeToggol.addEventListener('click', function() {
            document.querySelector('.nav_list').classList.remove('show_list');
            closeToggol.style.display = "none"
            navToggol.style.display = "block"

        })

        // profile
        const bloodWant = document.querySelector('#bloodWant');
        const bloodPopup = document.querySelector('.bloodPopup');
        const profile = document.querySelector('.profile');
        const overlay = document.querySelector('.overlay');

        bloodWant.addEventListener('click', function() {
            overlay.style.display = 'block';
            bloodPopup.style.display = 'block';
            profile.style.filter = 'blur(4px)';
        })
        overlay.addEventListener('click', function() {
            bloodPopup.style.display = 'none';
            overlay.style.display = 'none';
            profile.style.filter = 'blur(0px)';
        })

        // const myProfile = document.querySelector('#myProfile');
        // const birthAdd = document.querySelector('#birthAdd');
        // const ParmamentAdd = document.querySelector('#ParmAdd');
        // const currentAdd = document.querySelector('#currAdd');
        // const checkProfiles = document.querySelector('#checkProfiles');

        // // continue__
        // const profileNext = document.querySelector('#profileNext');
        // const birthNext = document.querySelector('#birthNext');
        // const parmNext = document.querySelector('#parmNext');
        // const currNext = document.querySelector('#currNext');

        // function allProfile() {
        //     myProfile.style.display = 'none';
        //     birthAdd.style.display = 'none';
        //     ParmamentAdd.style.display = 'none';
        //     currentAdd.style.display = 'none';
        //     checkProfiles.style.display = 'none';
        // }
        // profileNext.addEventListener('click', function() {
        //     allProfile()
        //     birthAdd.style.display = 'block';
        // })
        // birthNext.addEventListener('click', function() {
        //     allProfile()
        //     ParmamentAdd.style.display = 'block';
        // })
        // parmNext.addEventListener('click', function() {
        //     allProfile()
        //     currentAdd.style.display = 'block';
        //     console.log('clicked');
        // })
        // currNext.addEventListener('click', function() {
        //     allProfile()
        //     checkProfiles.style.display = 'block';
        // })
        // ---------- Footer ----------
        const hero = document.querySelector('.hero');
        const privacyText = document.querySelector('.privacy_text');
        const aboutText = document.querySelector('.about_text');
        const transCondi = document.querySelector('.trans_condition');

        function footerAll() {
            hero.style.display = 'none';
            privacyText.style.display = 'none';
            aboutText.style.display = 'none';
            transCondi.style.display = 'none';
        }

        function Privacy() {
            footerAll();
            privacyText.style.display = 'block';
        }

        function About() {
            footerAll();
            aboutText.style.display = 'block';
        }

        function TransCondition() {
            footerAll();
            transCondi.style.display = 'block';
        }

        // =============== Profile Country Code
        // const phoneInputField = document.querySelector("#phone");
        // const phoneInput = window.intlTelInput(phoneInputField, {
        //     initialCountry: "bd", // Set default country code
        //     separateDialCode: true, // Shows the country code separately
        //     utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js" // For extra functionality
        // });

        // // To handle form submission and save the formatted number
        // document.querySelector("form").addEventListener("submit", function(e) {
        //     const phoneNumber = phoneInput.getNumber();
        //     phoneInputField.value = phoneNumber; // Update the input value to include the country code
        // });
        function previewImage(event) {
            var file = event.target.files[0];
            var reader = new FileReader();

            reader.onload = function(e) {
                // Set the image preview to the selected file
                document.getElementById('profileImagePreview').src = e.target.result;
                // Enable the submit button
                document.getElementById('submitBtn').disabled = false;
            };

            if (file) {
                reader.readAsDataURL(file); // Read the selected file
            }
        }

        // Function to submit the form using AJAX
        function previewImage(event) {
            var file = event.target.files[0];
            var reader = new FileReader();

            reader.onload = function(e) {
                document.getElementById('profileImagePreview').src = e.target.result;
                document.getElementById('submitBtn').disabled = false;
            };

            if (file) {
                reader.readAsDataURL(file); // Preview the selected file
            }
        }

        // Function to submit the form using AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('#profilePicForm').submit(function(e) {
            e.preventDefault(); // Prevent the default form submission

            var formData = new FormData(this); // Collect form data including the file
            $.ajax({
                url: '{{ route('update.profile.image') }}', // URL for the update route
                type: 'PUT', // Use PUT method for updating the profile
                data: formData, // Pass the form data (including the image file)
                dataType: 'json', // Expect a JSON response
                contentType: false, // Don't set content-type because FormData will handle it
                processData: false, // Don't process the data, let FormData handle it
                success: function(response) {
                    if (response.success) {
                        // If the upload is successful, you can display the updated image
                        $('#profileImagePreview').attr('src', response
                            .imageUrl); // Update the profile image
                        alert('Profile image updated successfully!');
                    } else {
                        // If there's an error, display the error message
                        alert(response.message || 'Failed to update profile image.');
                    }
                },
                error: function(xhr, status, error) {
                    // Handle any error that occurs during the request
                    console.log(xhr.responseText);
                    alert('An error occurred while updating the profile image.');
                }
            });
        });
    </script>
    <!-- ---------- JS end ---------- -->
@endsection
