@extends('frontend.layouts.app')
@section('content')
    <!-- ---------- ons ---------- -->
    <section class="ons hero eduction-page">
        <div class="container">
            @foreach ($entrepreneurs as $entrepreneur)
                <div class="entrepreneur-wrapper">
                    <div class="ceo_img  entrepreneur-img">
                        <img src="{{ asset('developer/' . $entrepreneur->image) }}" alt="CEO Image">
                    </div>
                    <div class="ceo_text eduction-content entrepreneur-content">
                        <h2 class="eduction-title">{{ $entrepreneur->name }}</h2>
                        <h4 class="entrepreneur-position">{{ $entrepreneur->Position }}</h4>
                        <p>
                            <span id="description">{{ $entrepreneur->Description }}</span>
                            <span id="toggleButton" class="eduction-see-more-btn">See More</span>
                        </p>
                    </div>
                </div>
            @endforeach

            {{-- <div class="member_content">
                @foreach ($developers->chunk(2) as $chunk)
            <div class="ons_member">
                <div class="ms">
                    <h4>Member</h4>
                    <h4>Speece</h4>
                </div>
                @foreach ($chunk as $developer)
                <div class="member_data">
                    <div class="member_img">
                        <img src="frontend/assets/Image/developer_img/{{$developer->image}}" alt="CEO Image">
                        <h5>{{$developer->name}}</h5>
                        <h5>{{$developer->Position}}</h5>
                        <a href="{{$developer->SocialMediaLink}}" style="color: #0d6efd">Github</a>
                    </div>
                    <div class="member_speece">
                        <p>
                            {{$developer->Description}}
                        </p>
                    </div>
                </div>
                @endforeach
            </div>
                @endforeach
        </div> --}}

    </section>

    <!-- ---------- Trans And Condition end ---------- -->
@endsection
@section('script-js')
    <script>
        const description = document.getElementById('description');
        const toggleButton = document.getElementById('toggleButton');

        const fullText = description.innerText; // Get the full text
        const shortText = fullText.substring(0, 00) + '...'; // Get the first 100 characters with ellipsis

        // Initialize the description with short text
        description.innerText = shortText;

        toggleButton.addEventListener('click', () => {
            if (description.innerText === shortText) {
                description.innerText = fullText; // Show full text
                toggleButton.innerText = 'See Less'; // Change button text
            } else {
                description.innerText = shortText; // Show short text
                toggleButton.innerText = 'See More'; // Change button text
            }
        });
    </script>
@endsection
