@extends('frontend.layouts.app')
@section('content')
    <!-- ---------- ons ---------- -->
    <section class="ons hero eduction-page">
        <div class="container">
            @foreach ($educations as $education)
            <div class="ons_ceo eduction-wrapper">
                <div class="ceo_img ">
                    <img src="{{ asset('education/' . $education->image) }}" alt="CEO Image">
                </div>
                <div class="ceo_text eduction-content">
                    <h2 class="eduction-title">{{ $education->name }}</h2>
                    <p>
                        <span id="description">{{ $education->text }}</span>
                        <span id="toggleButton" class="eduction-see-more-btn">See More</span>
                    </p>
                    <div class="eduction-donate-item">
                        <button class="eduction-donate-btn"><span>Donate</span>
                            <span>
                                <svg width="20" height="19" viewBox="0 0 20 19" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10 18.35L8.55 17.03C3.4 12.36 0 9.27 0 5.5C0 2.41 2.42 0 5.5 0C7.24 0 8.91 0.81 10 2.08C11.09 0.81 12.76 0 14.5 0C17.58 0 20 2.41 20 5.5C20 9.27 16.6 12.36 11.45 17.03L10 18.35Z"
                                        fill="#FF0000" />
                                </svg>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        @endforeach

            {{-- <div class="member_content">
                @foreach ($developers->chunk(2) as $chunk)
            <div class="ons_member">
                <div class="ms">
                    <h4>Member</h4>
                    <h4>Speece</h4>
                </div>
                @foreach ($chunk as $developer)
                <div class="member_data">
                    <div class="member_img">
                        <img src="frontend/assets/Image/developer_img/{{$developer->image}}" alt="CEO Image">
                        <h5>{{$developer->name}}</h5>
                        <h5>{{$developer->Position}}</h5>
                        <a href="{{$developer->SocialMediaLink}}" style="color: #0d6efd">Github</a>
                    </div>
                    <div class="member_speece">
                        <p>
                            {{$developer->Description}}
                        </p>
                    </div>
                </div>
                @endforeach
            </div>
                @endforeach
        </div> --}}

    </section>

    <!-- ---------- Trans And Condition end ---------- -->
@endsection
@section('script-js')
    <script>
        const description = document.getElementById('description');
        const toggleButton = document.getElementById('toggleButton');

        const fullText = description.innerText; // Get the full text
        const shortText = fullText.substring(0, 500) + '...'; // Get the first 100 characters with ellipsis

        // Initialize the description with short text
        description.innerText = shortText;

        toggleButton.addEventListener('click', () => {
            if (description.innerText === shortText) {
                description.innerText = fullText; // Show full text
                toggleButton.innerText = 'See Less'; // Change button text
            } else {
                description.innerText = shortText; // Show short text
                toggleButton.innerText = 'See More'; // Change button text
            }
        });
    </script>
@endsection
