<div class="row">
    <div class="col-12">
        <p class="fs-normal mb-3">@lang('common.total_data_found') : <b class="badge bg-success">{{ count($datas) }}</b></p>
    </div>

    @foreach ($datas as $data)
        <div class="col-sm-6 col-lg-4 col-xl-3">
            <div class="block block-rounded">
                <div class="block-header">
                    <a href="{{ route('admin.professions.index', ['profession_id' => $data->id]) }}"
                        class="flex-grow-1 text-muted fs-md fw-bold">
                        @if ($lang == 'en')
                            {{ $data->title ?: $data->title_bn }}
                        @else
                            {{ $data->title_bn ?: $data->title }}
                        @endif
                    </a>
                    <div class="block-options">
                        <div class="dropdown">
                            <button type="button" class="btn-block-option" data-bs-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-ellipsis-v"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item show-modal"
                                    data-url="{{ route('admin.professions.edit', $data->id) }}">
                                    <i class="fa fa-fw fa-pencil-alt me-1"></i> @lang('common.edit')
                                </a>
                                <a class="dropdown-item text-danger show-modal"
                                    data-url="{{ route('admin.professions.delete', $data->id) }}">
                                    <i class="fa fa-fw fa-times me-1"></i> @lang('common.delete')
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>

@push('scripts')
    <script>
        $(document).on('click', '.show-modal', function(e) {
            e.preventDefault();
            let url = $(this).data('url');

            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    // Assuming you're loading the form into a modal
                    $('#modal-content').html(response); // Insert form HTML into modal content
                    $('#editModal').modal('show'); // Show the modal
                },
                error: function(xhr, status, error) {
                    console.error("Error loading edit form:", error);
                }
            });
        });
    </script>
@endpush
