{{-- <div class="modal-dialog modal-lg modal-dialog-popout" role="document">
    <div class="modal-content">
        <div class="block block-rounded block-themed block-transparent mb-0">
            <div class="block-header bg-gd-default">
                <h3 class="block-title">@lang('hospital.create_title')</h3>
                <div class="block-options">
                    <button type="button" class="btn-block-option" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa fa-fw fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="block-content">
                <!-- Form Grid with Labels -->
                <form method="POST" class="submit-form" action="{{ route('admin.hospitals.store') }}">
                    @csrf
                    <div class="row">
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Division">Division</label>
                                <div class="form_select">
                                    <select id="division" name="division" required>
                                        <option value="" selected>Select</option>
                                        @foreach ($divisions as $division)
                                            <option value="{{ $division->id }}">{{ $division->title ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="District">District/Municipality/Cantonment </label>
                                <div class="form_select">
                                    <select id="district" name="district" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Upzilla">Upzilla/Pourashava</label>
                                <div class="form_select">
                                    <select id="upzilla" name="upzilla" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title')</label>
                            <input type="text" class="form-control" name="title" value="{{ old('title') }}">
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title_bn')</label>
                            <input type="text" class="form-control" name="title_bn" value="{{ old('title_bn') }}">
                        </div>

                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.code')</label>
                            <input type="text" class="form-control" name="code" value="{{ old('code') }}">
                        </div>
                    </div>


                    <button type="submit" class="btn btn-sm btn-outline-primary mb-3">
                        @lang('hospital.save_hospital')
                    </button>

                </form>
                <!-- END Form Grid with Labels -->
            </div>
            <div class="block-content block-content-full text-end bg-gray-lighter">
                <button type="button" class="btn btn-sm btn-danger" data-bs-dismiss="modal">@lang('common.close')</button>
            </div>
        </div>
    </div>
</div> --}}


@extends('admin.layouts.app')

@section('title')
    @lang('hospital.index_title')
@endsection



@section('content')
    <!-- Top Products and Latest Orders -->
    <div class="row">
        <div class="col-12">
            <!-- Top Products -->
            <div class="block block-rounded">
                <div class="block-header block-header-default">
                    <h3 class="block-title">@lang('hospital.list_of_hospital')</h3>
                    <div class="block-options">
                        <button type="button" class="btn btn-sm btn-primary show-modal"
                            data-url="{{ route('admin.hospitals.create') }}">
                            <i class="fa fa-plus"></i> @lang('common.create_new')
                        </button>
                    </div>
                </div>
            </div>
            <!-- END Top Products -->

            <div class="block-content">
                <!-- Form Grid with Labels -->
                <form method="POST" class="submit-form" action="{{ route('admin.hospitals.store') }}">
                    @csrf
                    <div class="row">
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Division">Division</label>
                                <div class="form_select">
                                    <select id="division" name="division_id" required>
                                        <option value="" selected>Select</option>
                                        @foreach ($divisions as $division)
                                            <option value="{{ $division->id }}">{{ $division->title ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="District">District/Municipality/Cantonment </label>
                                <div class="form_select">
                                    <select id="district" name="district_id" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Upzilla">Upzilla/Pourashava</label>
                                <div class="form_select">
                                    <select id="upzilla" name="upazilla_id" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title')</label>
                            <input type="text" class="form-control" name="title" value="{{ old('title') }}">
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title_bn')</label>
                            <input type="text" class="form-control" name="title_bn" value="{{ old('title_bn') }}">
                        </div>

                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.code')</label>
                            <input type="text" class="form-control" name="code" value="{{ old('code') }}">
                        </div>
                    </div>


                    <button type="submit" class="btn btn-sm btn-outline-primary mb-3">
                        @lang('hospital.save_hospital')
                    </button>

                </form>
                <!-- END Form Grid with Labels -->
            </div>



        </div>

    </div>
    <!-- END Top Products and Latest Orders -->
@endsection

@push('scripts')
    <script>
        function get_data() {
            $.ajax({
                url: @json(route('admin.hospitals.get_data')),
                method: 'GET',
                success: function(response) {
                    $('#data-view').html(response);
                }
            });
        }

        $(document).ready(function() {
            get_data();
        });

        $('#division').change(function(e) {
            var divisionId = e.target.value; // Get the selected division id
            if (divisionId) { // Ensure divisionId is not empty
                $.ajax({
                    url: window.origin + '/api/v1/districts?division_id=' + divisionId,
                    method: 'get',
                    success: function(res) {
                        if (res.status === 'success') {
                            $('#district').empty(); // Clear previous district options

                            var container = document.getElementById('district');
                            addOption(container, 'Select Option', '', true); // Add placeholder
                            res.data.forEach((item) => {
                                addOption(container, item.title, item.id,
                                    false); // Add district options
                            });
                        }
                    }
                });
            }
        });


        $('#district').change(function(e) {
            var districtId = e.target.value;
            $.ajax({
                url: window.origin + '/api/v1/upzillas?district_id=' + districtId,
                method: 'get',
                success: function(res) {
                    if (res.status === 'success') {
                        $('#upzilla').empty();

                        var container = document.getElementById('upzilla');
                        addOption(container, 'Select Option', '', true);
                        res.data.forEach((item, i) => {
                            addOption(container, item.title, item.id, false);
                        })
                    }
                }
            })
        })


        function addOption(container, text, value, selected) {
            var item = document.createElement('option');
            item.textContent = text;

            if (value) item.setAttribute('value', value);
            if (selected) item.setAttribute('selected', selected);

            container.appendChild(item);
        }
    </script>
@endpush
