@extends('admin.layouts.app')

@section('title')
    Contact Us
@endsection



@section('content')
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-2 float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">
        Add Contact
    </button><br>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add Contact</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.contact.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label>Title:</label>
                            <input class="form-control" name="title" placeholder="Write a title">
                        </div>
                        <div>
                            <label>Bangla Title:</label>
                            <input class="form-control" name="bn_title" placeholder="Write a bangla title">
                        </div>

                        <div>
                            <label>Description:</label>
                            <textarea class="form-control" name="description" cols="30" rows="4"></textarea>
                        </div>
                        <div>
                            <label>Bangla Description:</label>
                            <textarea class="form-control" name="bn_description" cols="30" rows="4"></textarea>
                        </div>
                        <div>
                            <label>Contact Phone :</label>
                            <input class="form-control" name="contact_phone" placeholder="Write a contact phone">
                        </div>
                        <div>
                            <label>Contact Email :</label>
                            <input class="form-control" name="contact_email" placeholder="Write a contact email">
                        </div>
                        <div>
                            <label>Contact Map Link :</label>
                            <input class="form-control" name="contact_map_link" placeholder="Write a contact map link">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <br>


    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Bangla Title</th>
                    <th>Description</th>
                    <th>Bangla Description</th>
                    <th>Contact Phone</th>
                    <th>Contact Email</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($contacts as $contact)
                    <tr>
                        <td>{{ $contact->title }}</td>
                        <td>{{ $contact->bn_title }}</td>
                        <td>{{ $contact->description }}</td>
                        <td>{{ $contact->bn_description }}</td>
                        <td>{{ $contact->contact_phone }}</td>
                        <td>{{ $contact->contact_email }}</td>
                        <td>
                            <a style="float: left;margin-right:10px;" class="btn btn-warning"
                                href="{{ route('admin.contact.edit', $contact->id) }}">Edit</a>
                            <form method="post" action="{{ route('admin.contact.destroy', $contact->id) }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
    </div>
@endsection
