@extends('admin.layouts.app')

@section('title')
    New Foundation
@endsection



@section('content')
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-2 float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">
        Add New Foundation
    </button><br>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add New Foundation</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.add-new-foundation.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label>Name:</label>
                            <input class="form-control" name="name" placeholder="Write a name">
                        </div>
                        <div>
                            <label>Email:</label>
                            <input class="form-control" name="email" placeholder="Write your position">
                        </div>
                        <div>
                            <label>Phone:</label>
                            <input class="form-control" name="mobile" placeholder="Write your position">
                        </div>
                        <div>
                            <label>Password:</label>
                            <input class="form-control" name="password" placeholder="Write your social media link">
                        </div>

                        <div>
                            <label for="status">Status:</label>
                            <div class="d-flex align-items-center justify-content-center gap-3">
                                <input type="checkbox" name="status" id="status" value="1">
                                <label>Active</label>
                            </div>
                        </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    <br>


    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Account ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($foundations as $foundation)
                    <tr @if (isset($selectedfoundation) && $selectedfoundation->id === $foundation->id) style="background-color: #f0f0f0;" @endif>
                        <td>{{ $foundation->account_id }}</td>
                        <td>{{ $foundation->name }}</td>
                        <td>{{ $foundation->email }}</td>
                        <td>{{ $foundation->mobile }}</td>
                        <td>
                            <a class="btn btn-warning" href="{{ route('admin.add-new-foundation.edit', $foundation->id) }}">Edit</a>
                            <form method="post" action="{{ route('admin.add-new-foundation.destroy', $foundation->id) }}"
                                style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            {{-- <tfoot>
                <tr>
                    <th>Name</th>
                    <th>Bangla Name</th>
                    <th>Position</th>
                    <th>Bangla Position</th>
                    <th>Social Media Link</th>
                    <th>Description</th>
                    <th>Bangla Description</th>
                    <th>Image</th>
                    <th>Action</th>
                </tr>
            </tfoot> --}}
        </table>
    </div>


@endsection
