@extends('admin.layouts.app')

@section('title')
    About
@endsection



@section('content')
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-2 float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">
        Add About
    </button><br>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add About</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.abouts.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label>Title:</label>
                            <input class="form-control" name="title" placeholder="Write a title">
                        </div>
                        <div>
                            <label>Bangla Title:</label>
                            <input class="form-control" name="bn_title" placeholder="Write a bangla title">
                        </div>

                        <div>
                            <label>Description:</label>
                            <textarea class="form-control" name="description" cols="30" rows="10"></textarea>
                        </div>
                        <div>
                            <label>Bangla Description:</label>
                            <textarea class="form-control" name="bn_description" cols="30" rows="10"></textarea>
                        </div>
                        <div>
                            <label>Image:</label>
                            <input class="form-control" name="image" type="file">
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <br>


    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Bangla Title</th>
                    <th>Description</th>
                    <th>Bangla Description</th>
                    <th>Image</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($abouts as $about)
                    <tr>
                        <td>{{ $about->title }}</td>
                        <td>{{ $about->bn_title }}</td>
                        <td>{{ $about->description }}</td>
                        <td>{{ $about->bn_description }}</td>
                        <td><img height="100" width="100" src="{{ asset($about->image) }}"></td>
                        <td>
                            <a style="float: left;margin-right:10px;" class="btn btn-warning"
                                href="{{ route('admin.abouts.edit', $about->id) }}">Edit</a>
                            <form method="post" action="{{ route('admin.abouts.destroy', $about->id) }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
    </div>
@endsection
