<?php

namespace App\Repository;

use App\Models\Hospital;
use App\Models\Upazilla;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class HospitalRepository
{
    public static function get()
    {
        $data = Hospital::latest();

        if (auth('admin')->check()) {
            $data->accessible();
        }

        return $data->get();
    }
    public static function create($request)
    {
        DB::beginTransaction();
        try {
            $upazilla = Upazilla::findOrFail($request->upazilla_id);
            $hospitalData = [
                'title' => $request->title,
                'title_bn' => $request->title_bn,
                'code' => $request->code,
                'division_id' => $upazilla->division_id,
                'district_id' => $upazilla->district_id,
                'upazilla_id' => $upazilla->id,
                'created_by' => auth()->id(),
            ];
            Hospital::create($hospitalData);
            DB::commit();
            return redirect()->route('admin.hospitals.index')->with('success', 'Hospital created successfully.');
        } catch (Exception $exception) {
            DB::rollBack();
            return back()->with('error', $exception->getMessage());
        }
    }

    public static function update($request, $id)
    {
        $validator = Validator::make($request->all(), [
            "title" => "required",
        ]);

        $input = $request->except('_token');

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()]);
        } else {

            if (Hospital::find($id)->update($input)) {
                return response()->json(['success' => __('hospital.update_message')]);
            } else {
                return response()->json(['error' => 'Data Does not insert.someting went to wrong. please try again!']);
            }
        }
    }

    public static function delete($id)
    {
        if (Hospital::find($id)->delete()) {
            return response()->json(['success' => 'Hospital deleted successfully done!']);
        } else {
            return response()->json(['error' => 'Data Does not deleted.someting went to wrong. please try again!']);
        }
    }

    public static function bluk_update($request)
    {
        $input = $request->only(['status']);

        if ($request->has('status') && $request->status == 1) {
            $input['status'] = 1;
        }

        if ($request->has('ids')) {
            $ids = $request->ids;
            foreach ($ids as $id) {
                Hospital::find($id)->update($input);
            }

            return response()->json(['success' => 'Hospital bulk changed successfully done!']);
        }

        return response()->json(['error' => 'Someting went to wrong. please try again!']);
    }

    public static function bluk_delete($request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            if ($id != null) {
                Hospital::find($id)->delete();
            } else {
                return response()->json(['error' => 'Someting went to wrong. please try again!']);
            }
        }
        return response()->json(['success' => 'Hospital deleted successfully done!']);
    }
}