<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class HospitalRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|string|unique:hospitals,title',
            'title_bn' => 'nullable|string',
            'code' => 'nullable|string',
            'upazilla_id' => 'required|exists:upazillas,id',
            'district_id' => 'required|exists:districts,id',
            'division_id' => 'required|exists:divisions,id',
        ];
    }
    public function messages()
    {
        return [
            'title.required' => __('hospital.title_required'),
        ];
    }
}