<?php

namespace App\Http\Controllers\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BloodRequest;
use Illuminate\Support\Facades\Auth;


class UserDashboardController extends Controller
{
    public function index()
    {
        $total = [];
        $today = now()->startOfDay();
        $total['today_blood_request'] = BloodRequest::whereDate('created_at', $today)->count();
        $total['blood_request'] = BloodRequest::count();

        return view('user.dashboard', compact('total'));
    }
}