<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\ContactUs;
use App\Models\Developer;
use App\Models\Education;
use App\Models\Gallery;
use App\Models\Privacy;
use App\Models\Sponsor;
use App\Models\TramsCondition;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function Education()
    {
        $educations = Education::all();
        return view('frontend.pages.education', compact("educations"));
    }
    public function Health()
    {
        return view('frontend.pages.health');
    }
    public function FoodForAll()
    {
        return view('frontend.pages.food-for-all');
    }

    public function Entrepreneur()
    {
        $entrepreneurs = Developer::all();
        return view('frontend.pages.entrepreneur', compact('entrepreneurs'));
    }
    public function about()
    {
        $about = About::latest()->first();
        $sponsors = Sponsor::all();
        return view('frontend.pages.about', compact('sponsors', 'about'));
    }
    public function privacyPolicy()
    {
        $sponsors = Sponsor::all();
        $privacy = Privacy::latest()->first();
        return view('frontend.pages.privacy', compact('sponsors', 'privacy'));
    }
    public function tramsCondition()
    {
        $sponsors = Sponsor::all();
        $tramsCondition = TramsCondition::latest()->first();
        return view('frontend.pages.trams-condition', compact('sponsors', 'tramsCondition'));
    }
    public function contactUs()
    {
        $contact = ContactUs::latest()->first();
        return view('frontend.pages.contact-us', compact('contact'));
    }
    public function Gallery()
    {
        $galleries = Gallery::all();
        return view('frontend.pages.gallery', compact('galleries'));
    }
    public function gallerySingle($id)
    {
        $gallery = Gallery::findOrFail($id);  
    return view('frontend.pages.gallery-single', compact('gallery'));
    }
}