<?php

namespace App\Http\Controllers\Hospital;

use App\Models\FoundationContactUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class HospitalDashboardController extends Controller
{
    public function dashboard(){
        return view('hospital.dashboard');
    }

    public function logout(Request $request)
    {
        Auth::guard('hospital')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('hospital.login');
    }
    public function contact(){
        $contacts=FoundationContactUs::all();
        return view('hospital.contact',compact('contacts'));
    }
}