<?php

namespace App\Http\Controllers\Admin;

use App\Models\Profession;
use App\Http\Requests\HospitalRequest;
use App\Http\Controllers\Controller;
use App\Http\Requests\ProfessionRequest;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Models\ProfessionTranslation;
use App\Repository\ProfessionRepository;
use Illuminate\Support\Facades\DB;

class ProfessionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.professions.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.professions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProfessionRequest $request)
    {
        return ProfessionRepository::create($request);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\profession  $profession
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\profession  $profession
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $profession = Profession::findOrFail($id);
        return view('admin.professions.edit', compact('profession'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\profession  $profession
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return ProfessionRepository::update($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\profession  $profession
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return ProfessionRepository::delete($id);
    }

    public function delete($id)
    {
        return view('admin.professions.delete', compact('id'));
    }

    public function get_data()
    {
        $datas = ProfessionRepository::get();
        return view('admin.professions.data', compact('datas'));
    }

    public function translation($id, $lang_id)
    {
        $profession = Profession::findOrFail($id);
        $language = Language::find($lang_id);

        if ($language != null) {
            $translation = ProfessionTranslation::where('profession_id', $id)->where('language_id', $lang_id)->first();
            return view('admin.professions.translation', compact('profession', 'language', 'translation'));
        } else {
            return response()->json(['error' => 'You Have No Language Active.Someting went to wrong. please try again!']);
        }
    }

    public function save_translation(Request $request, $id, $lang_id)
    {

        $input = $request->except('_token');

        $input['profession_id'] = $id;
        $input['language_id'] = $lang_id;

        if (ProfessionTranslation::updateOrCreate(['language_id' => $lang_id, 'profession_id' => $id], $input)) {
            return response()->json(['success' => 'Profession Transalation updated successfully done!']);
        } else {
            return response()->json(['error' => 'Data Does not insert.someting went to wrong. please try again!']);
        }
    }

    public function all_translation($id)
    {
        $all_professions = ProfessionRepository::get();
        $language      = Language::findOrFail($id);

        $professions = $all_professions->map(function ($profession) use ($language) {
            $translation = ProfessionTranslation::where('profession_id', $profession->id)->where('language_id', $language->id)->first();
            return [
                'id'    => $profession->id,
                'title' => $translation->title ?? $profession->title,
            ];
        });

        return view('admin.professions.all-translation', compact('professions', 'language'));
    }

    public function save_all_translation(Request $request, $id)
    {

        $language_id   = $id;
        $total_request = count($request->id);

        DB::beginTransaction();
        for ($i = 0; $i < $total_request; $i++) {
            $input['language_id'] = $language_id;
            $input['profession_id'] = $request->id[$i];
            $input['title']       = $request->title[$i];

            ProfessionTranslation::updateOrCreate(['language_id' => $language_id, 'profession_id' => $input['profession_id']], $input);
        }
        DB::commit();

        return response()->json(['success' => 'All profession Transalation updated successfully done!']);
    }
}
