<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Privacy;
use Illuminate\Http\Request;

class PrivacyController extends Controller
{
    public function index()
    {
        $privacys = Privacy::all();
        return view('admin.privacy.index', compact('privacys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        $privacy = new Privacy();
        $privacy->title = $validatedData['title'];
        $privacy->description = $validatedData['description'];
        $privacy->bn_title = $validatedData['bn_title'];
        $privacy->bn_description = $validatedData['bn_description'];

        // Handling image upload
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/privacy'), $imageName);
            $privacy->image = 'admin/privacy/' . $imageName;
        }

        $privacy->status = $request->has('status') ? true : false;
        $privacy->save();

        // Redirect with a success message
        return redirect()->route('admin.privacys.index')->with('success', 'privacy section created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $privacy = privacy::findOrFail($id);
        return view('admin.privacy.edit', compact('privacy'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        // Find the existing privacy record
        $privacy = privacy::findOrFail($id);

        // Update text fields
        $privacy->title = $validatedData['title'];
        $privacy->description = $validatedData['description'];
        $privacy->bn_title = $validatedData['bn_title'];
        $privacy->bn_description = $validatedData['bn_description'];

        // Check if a new image is uploaded
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            // Remove the old image if it exists
            if ($privacy->image && file_exists(public_path($privacy->image))) {
                unlink(public_path($privacy->image));
            }

            // Upload the new image
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/privacy'), $imageName);

            // Update the image path
            $privacy->image = 'admin/privacy/' . $imageName;
        }

        // Update the status
        $privacy->status = $request->has('status') ? true : false;

        // Save the updated record
        $privacy->save();

        // Redirect with a success message
        return redirect()->route('admin.privacys.index')->with('success', 'privacy section updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $privacy = privacy::findOrFail($id);
        if ($privacy->image && file_exists(public_path($privacy->image))) {
            unlink(public_path($privacy->image));
        }

        $privacy->delete();
        return redirect()->route('admin.privacys.index')->with('success', 'privacy section deleted successfully');
    }
}