<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\HospitalRequest;
use App\Models\District;
use App\Models\Division;
use App\Models\Hospital;
use App\Models\HospitalTranslation;
use App\Models\Language;
use App\Models\Upazilla;
use App\Repository\HospitalRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HospitalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.hospitals.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $divisions = Division::query()->select(['id', 'title'])->get();
        return view('admin.hospitals.create', compact('divisions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate incoming data
        $validatedData = $request->validate([
            'title' => 'required|string|unique:hospitals,title',
            'title_bn' => 'nullable|string',
            'code' => 'nullable|string',
            'division_id' => 'required|exists:divisions,id',
            'district_id' => 'required|exists:districts,id',
            'upazilla_id' => 'required|exists:upazillas,id',
        ]);

        // Create new hospital entry
        $hospital = new Hospital();
        $hospital->title = $validatedData['title'];
        $hospital->title_bn = $validatedData['title_bn'];
        $hospital->code = $validatedData['code'];
        $hospital->division_id = $validatedData['division_id'];
        $hospital->district_id = $validatedData['district_id'];
        $hospital->upazilla_id = $validatedData['upazilla_id'];
        $hospital->created_by = Auth::id(); // Assuming the logged-in user is the creator
        $hospital->save();

        // Optionally, if you want to store translations in a HospitalTranslation model:

        // Redirect or return a response

        return redirect()->route('hospitals.index')->with('success', 'Hospital created successfully.');
    }
    // public function store(HospitalRequest $request)
    // {
    //     return HospitalRepository::create($request);
    // }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hospital = Hospital::findOrFail($id);
        return view('admin.hospitals.edit', compact('hospital'));
    }
    // public function getDistricts($division_id)
    // {
    //     $districts = District::where('division_id', $division_id)->select('id', 'title')->get();
    //     dd($districts);
    //     return response()->json($districts);
    // }

    // public function getUpazilas($district_id)
    // {
    //     $upazilas = Upazilla::where('district_id', $district_id)->select('id', 'title')->get();
    //     return response()->json($upazilas);
    // }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return HospitalRepository::update($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return HospitalRepository::delete($id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        return view('admin.hospitals.delete', compact('id'));
    }

    public function get_data()
    {
        $datas = HospitalRepository::get();
        return view('admin.hospitals.data', compact('datas'));
    }

    public function translation($id, $lang_id)
    {
        $hospital = Hospital::findOrFail($id);
        $language = Language::find($lang_id);

        if ($language != null) {
            $translation = HospitalTranslation::where('hospital_id', $id)->where('language_id', $lang_id)->first();
            return view('admin.hospitals.translation', compact('hospital', 'language', 'translation'));
        } else {
            return response()->json(['error' => 'You Have No Language Active.Someting went to wrong. please try again!']);
        }
    }

    public function save_translation(Request $request, $id, $lang_id)
    {

        $input = $request->except('_token');

        $input['hospital_id'] = $id;
        $input['language_id'] = $lang_id;

        if (HospitalTranslation::updateOrCreate(['language_id' => $lang_id, 'hospital_id' => $id], $input)) {
            return response()->json(['success' => 'Hospital Transalation updated successfully done!']);
        } else {
            return response()->json(['error' => 'Data Does not insert.someting went to wrong. please try again!']);
        }
    }

    public function all_translation($id)
    {
        $all_hospitals = HospitalRepository::get();
        $language      = Language::findOrFail($id);

        $hospitals = $all_hospitals->map(function ($hospital) use ($language) {
            $translation = HospitalTranslation::where('hospital_id', $hospital->id)->where('language_id', $language->id)->first();
            return [
                'id'    => $hospital->id,
                'title' => $translation->title ?? $hospital->title,
            ];
        });

        return view('admin.hospitals.all-translation', compact('hospitals', 'language'));
    }

    public function save_all_translation(Request $request, $id)
    {

        $language_id   = $id;
        $total_request = count($request->id);

        DB::beginTransaction();
        for ($i = 0; $i < $total_request; $i++) {
            $input['language_id'] = $language_id;
            $input['hospital_id'] = $request->id[$i];
            $input['title']       = $request->title[$i];

            HospitalTranslation::updateOrCreate(['language_id' => $language_id, 'hospital_id' => $input['hospital_id']], $input);
        }
        DB::commit();

        return response()->json(['success' => 'All Hospital Transalation updated successfully done!']);
    }
}