<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\Gallery;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $galleries = Gallery::all();
        return view('admin.gallery.index', compact('galleries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'name' => 'nullable|string',
            'bn_name' => 'nullable|string',
            'home_location' => 'nullable|string',
            'bn_home_location' => 'nullable|string',
            'reference_name' => 'nullable|string',
            'bn_reference_name' => 'nullable|string',
            'description' => 'nullable|string',
            'reference' => 'nullable|string',
            'reference_location' => 'nullable|string',
            'bn_reference_location' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);
        $gallery = new Gallery();
        $gallery->name = $validatedData['name'];
        $gallery->bn_name = $validatedData['bn_name'];
        $gallery->home_location = $validatedData['home_location'];
        $gallery->bn_home_location = $validatedData['bn_home_location'];
        $gallery->reference_name = $validatedData['reference_name'];
        $gallery->bn_reference_name = $validatedData['bn_reference_name'];
        $gallery->reference_location = $validatedData['reference_location'];
        $gallery->bn_reference_location = $validatedData['bn_reference_location'];
        $gallery->description = $validatedData['description'];
        $gallery->bn_description = $validatedData['bn_description'];
        $gallery->user_id = auth()->id();
        $prefix = 'G';
        $generate = str_pad($gallery->id, '9', '0', STR_PAD_LEFT);
        $gallery->account_id = $prefix . $generate;
        // Handling image upload
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/gallery'), $imageName);
            $gallery->image = 'admin/gallery/' . $imageName;
        }
        $gallery->status = $request->has('status') ? true : false;
        $gallery->save();
        // Redirect with a success message
        return redirect()->route('admin.gallerys.index')->with('success', 'Gallery created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $gallery = Gallery::findOrFail($id);
        return view('admin.gallery.edit', compact('gallery'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'name' => 'nullable|string',
            'bn_name' => 'nullable|string',
            'home_location' => 'nullable|string',
            'bn_home_location' => 'nullable|string',
            'reference_name' => 'nullable|string',
            'bn_reference_name' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_description' => 'nullable|string',
            'reference_location' => 'nullable|string',
            'bn_reference_location' => 'nullable|string',
        ]);
        $gallery = Gallery::findOrFail($id);
        $gallery->name = $validatedData['name'];
        $gallery->bn_name = $validatedData['bn_name'];
        $gallery->home_location = $validatedData['home_location'];
        $gallery->bn_home_location = $validatedData['bn_home_location'];
        $gallery->reference_name = $validatedData['reference_name'];
        $gallery->bn_reference_name = $validatedData['bn_reference_name'];
        $gallery->description = $validatedData['description'];
        $gallery->reference_location = $validatedData['reference_location'];
        $gallery->bn_reference_location = $validatedData['bn_reference_location'];
        $gallery->bn_description = $validatedData['bn_description'];
        $gallery->user_id = auth()->id();
        $prefix = 'G';
        $generate = str_pad($gallery->id, '9', '0', STR_PAD_LEFT);
        $gallery->account_id = $prefix . $generate;
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            if ($gallery->image && file_exists(public_path($gallery->image))) {

                unlink(public_path($gallery->image));
            }
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/gallery'), $imageName);
            $gallery->image = 'admin/gallery/' . $imageName;
        }
        $gallery->status = $request->has('status') ? true : false;
        $gallery->save();
        return redirect()->route('admin.gallerys.index')->with('success', 'Gallery Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $gallery = Gallery::findOrFail($id);
        if ($gallery->image && file_exists(public_path($gallery->image))) {
            unlink(public_path($gallery->image));
        }

        $gallery->delete();
        return redirect()->route('admin.gallerys.index')->with('success', 'Gallery deleted successfully');
    }
    public function toggleSeen($id)
    {
        $gallery = Gallery::findOrFail($id);
        $gallery->seen = !$gallery->seen; // Toggle the 'seen' status
        $gallery->save();

        return redirect()->route('admin.gallerys.index')->with('success', 'Gallery status updated successfully');
    }
}
