<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Hospital;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AddNewHospitalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $hospitalId = $request->query('hospital_id');
        $hospitals = Hospital::all();

        // Optional: Highlight or focus on the selected user
        $selectedHospital = null;
        if ($hospitalId) {
            $selectedHospital = Hospital::find($hospitalId);
        }
        return view('admin.add-new-hospital.index', compact('hospitals', 'selectedHospital'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'nullable|email|unique:users,email',
            'name' => 'required',
            'mobile' => 'nullable',
            'password' => 'required',
        ]);
        $hospital = new Hospital();
        $hospital->email = $request->email;
        $hospital->name = $request->name;
        $hospital->mobile = $request->mobile;
        $hospital->password = Hash::make($request->password);
        $hospital->email_verified_at = $request->has('email_verified_at') ? now() : null;

        // Set status based on checkbox input (default to 0 if unchecked)
        $hospital->status = $request->has('status') ? 1 : 0;
        $hospital->save();

        // Generate and update account ID using the hospital ID
        $prefix = 'F';
        $generate = str_pad($hospital->id, 9, '0', STR_PAD_LEFT);
        $hospital->account_id = $prefix . $generate;
        $hospital->save();
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}